// PCIEDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PCIE.h"
#include "PCIEDlg.h"
#include ".\pciedlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CPCIEDlg dialog



CPCIEDlg::CPCIEDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPCIEDlg::IDD, pParent)
	, m_15I(0)
	, m_15V(0)
	, m_33V(0)
	, m_33I(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CPCIEDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_15I, m_15I);
	DDX_Text(pDX, IDC_15V, m_15V);
	DDX_Text(pDX, IDC_33V, m_33V);
	DDX_Text(pDX, IDC_33I, m_33I);
}

BEGIN_MESSAGE_MAP(CPCIEDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
//	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_BN_CLICKED(IDCANCEL, OnBnClickedCancel)
	ON_BN_CLICKED(IDC_BT_Pon, OnBnClickedBtPon)
	ON_BN_CLICKED(IDC_BT_Poff, OnBnClickedBtPoff)
	ON_BN_CLICKED(IDC_BT_DrEn, OnBnClickedBtDren)
	ON_BN_CLICKED(IDC_BT_DrDis, OnBnClickedBtDrdis)
	ON_BN_CLICKED(IDC_BT_BP, OnBnClickedBtBp)
	ON_BN_CLICKED(IDC_BT_VI, OnBnClickedBtVi)
	ON_BN_CLICKED(IDC_BT_Go_LED, OnBnClickedBtGoLed)
	ON_BN_CLICKED(IDC_BT_NoGo_LED, OnBnClickedBtNogoLed)
END_MESSAGE_MAP()


// CPCIEDlg message handlers

BOOL CPCIEDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

int status = pem.INIT();
	
	for (int i = 0; i < 4; i++)
	{
		pemvalid[i] = pem.VALIDPEM(i);
		if (pemvalid[i] == 1) 
		{
			// Find the current valid PEM Module
			currpemno = i;
		}
	}
	// Select PEM Module
	status = pem.SELPEM(currpemno);
	if (status != 0) AfxMessageBox("SELPEM Error!\n");
	//Current Calibrate

	
	status = pem.VALIDDEV();
	if (status == 1) 
	{
		// Device on Slot are Valid,
		// Same VID, DID
	}
	else 
	{
		AfxMessageBox("VALIDDEV Fail!  Need to Assign A New Device\n");
	}

	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CPCIEDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CPCIEDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CPCIEDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CPCIEDlg::OnBnClickedCancel()
{
    pem.EXIT();
	OnCancel();
}

void CPCIEDlg::OnBnClickedBtPon()
{
	int status;
	status = pem.PON();
	if (status != 0) AfxMessageBox("Power On Fail!");
	UpdateData(TRUE);
	status = pem.GETPWRSTS();
	if (status == 0) 
	{
		int vshort = pem.CHKSHORT();
		if (vshort & CPEMDLL_ERROR_3V3AUXSHORT) AfxMessageBox("3.3VAUX Rail Short!");
		if (vshort & CPEMDLL_ERROR_3V3SHORT) AfxMessageBox("3.3V Rail Short!");
		if (vshort & CPEMDLL_ERROR_1V5SHORT) AfxMessageBox("1.5V Rail Short!");		
	}
	else 
	{

	}

	UpdateData(FALSE);
}

void CPCIEDlg::OnBnClickedBtPoff()
{
    int status;
	status = pem.POFF();
	if (status != 0) AfxMessageBox("Power Off Fail!");	
	UpdateData(TRUE);
	status = pem.GETPWRSTS();

	UpdateData(FALSE);}

void CPCIEDlg::OnBnClickedBtDren()
{
	int status = pem.WINEN(200);
	if (status != 0) AfxMessageBox("Driver Enable Fail!");}

void CPCIEDlg::OnBnClickedBtDrdis()
{
    int status = pem.WINDIS(200);
	if (status != 0) AfxMessageBox("Driver Disable Fail!");	}

void CPCIEDlg::OnBnClickedBtBp()
{
	pem.BEEP(2, 2);}

void CPCIEDlg::OnBnClickedBtVi()
{
    int status;
	double dval;
	UpdateData(TRUE);
	status = pem.GET3V3V(&dval);
	if (status == 0) 
	{
		m_33V = dval;
	}
	else m_33V = 0;

	status = pem.GET3V3I(&dval);
	if (status == 0) 
	{
		m_33I = dval;
	}
	else m_33I = 0;

	status = pem.GET1V5V(&dval);
	if (status == 0) 
	{
		m_15V = dval;
	}
	else m_15V = 0;

	status = pem.GET1V5I(&dval);
	if (status == 0) 
	{
		m_15I = dval;
	}
	else m_15I = 0;

	UpdateData(FALSE);}

void CPCIEDlg::OnBnClickedBtGoLed()
{
	pem.LEDOFF();
	pem.LEDGO();
}

void CPCIEDlg::OnBnClickedBtNogoLed()
{
	pem.LEDOFF();
	pem.LEDNG();
}
